/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.world;

import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.mixins.accessors.GuiSelectWorldAccessor;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiWorldSelection;

public class SavesWatcher {
    private WatchService watchService;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Path savesFolder;
    private final ExecutorService executor;

    public SavesWatcher() {
        this.savesFolder = new File(this.mc.field_71412_D, "saves").toPath();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void watch() {
        this.executor.execute(() -> {
            try {
                WatchKey key;
                this.watchService = FileSystems.getDefault().newWatchService();
                this.savesFolder.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                while ((key = this.watchService.take()) != null) {
                    for (WatchEvent<?> ignored : key.pollEvents()) {
                        if (!(this.mc.field_71462_r instanceof GuiWorldSelection)) continue;
                        this.mc.func_152344_a(() -> {
                            if (this.mc.field_71462_r instanceof GuiWorldSelection) {
                                this.mc.func_147108_a(((GuiSelectWorldAccessor)new GuiWorldSelection(this.mc.field_71462_r)).getPrevScreen());
                            }
                        });
                    }
                    key.reset();
                }
            }
            catch (Exception e) {
                Patcher.instance.getLogger().error("Failed to watch for new saves.", (Throwable)e);
            }
        });
    }
}

